﻿#if       !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACT_CLIENT_CALLBACK)
#define            INCLUDED_SZ_ARCHIVE_FILE_EXTRACT_CLIENT_CALLBACK

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_TIME)
#include  <szTime.hpp>
#endif // !defined(INCLUDED_SZ_TIME)

SZ_NS_BEG(szpp)

/// <summary>
/// アーカイブをフォルダに展開する際の進行状況などをクライアントに知らせるためのコールバック型。
/// クライアント側で派生クラスを実装して、そのポインタを SevenZip++ に登録する。
/// </summary>
class SZ_SPEC ArchiveFileExtractClientCallback
{
public:

  /// AskOverwrite メソッドの answer パラメータとして返す値の列挙型。
  enum AskOverwriteAnswer
  {
    Yes,
    YesToAll,
    No,
    NoToAll,
    AutoRename,
    Cancel
  };

  // TODO: ほかの展開クラスと共通の場所に移動
  enum ExtractMode
  {
    Extract = 0,
    Test,
    Skip
  };

  // TODO: ほかの展開クラスと共通の場所に移動
  enum OperationResult
  {
    OK = 0,
    UnSupportedMethod,
    DataError,
    CRCError
  };

  // IProgress
  virtual HRESULT SetTotal(const u64 &total) = 0;
  virtual HRESULT SetCompleted(const u64 &completeValue) = 0;

  // IPassword
  virtual HRESULT CryptoGetTextPassword(szstring *password) = 0;

  // IFolderArchiveExtractCallback

  // existingName = Full Path (e.g. C:\Program Files\File.exe), newName = Relative Path (internal path of stored file; e.g. dir1\dir2\file.txt)
  virtual HRESULT AskOverwrite(
    const szstring &existingName, const Time &existingTime, const u64 &existingSize,
    const szstring &newName, const Time &newTime, const u64 &newSize,
    u32 *answer) = 0;
  virtual HRESULT PrepareOperation(const szstring &name, bool isFolder, u32 extractMode, const u64 &position) = 0;
  virtual HRESULT MessageError(const szstring &message) = 0;
  virtual HRESULT SetOperationResult(u32 operationResult, bool encrypted) = 0;

  // IExtractCallbackUI
  virtual HRESULT BeforeOpen(const szstring &name) = 0;
  virtual HRESULT OpenResult(const szstring &name, HRESULT result, bool encrypted) = 0;
  virtual HRESULT ThereAreNoFiles() = 0;
  virtual HRESULT ExtractResult(HRESULT result) = 0;
  virtual HRESULT SetPassword(const szstring &password) = 0;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACT_CLIENT_CALLBACK)
